/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.collect.AbstractIterator;
import com.google.gson.JsonObject;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TreeAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    private static final int MAX_BRANCH_DISTANCE = 10;
    private final int width;
    private final int depth;

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IAreaOfEffectIterator> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<class_2338> getBlocks(IToolStackView tool, class_1799 stack, class_1657 player, class_2680 state, class_1937 world, class_2338 origin, class_2350 sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return TreeAOEIterator.calculate(tool, stack, player, state, world, origin, sideHit, this.width + (expanded + 1) / 2, this.depth + expanded / 2, matchType);
    }

    public static Iterable<class_2338> calculate(IToolStackView tool, class_1799 stack, class_1657 player, class_2680 state, class_1937 world, class_2338 origin, class_2350 sideHit, int extraWidth, int extraDepth, IAreaOfEffectIterator.AOEMatchType matchType) {
        class_2350 widthDir;
        class_2350 depthDir;
        if (extraDepth > 0 || extraWidth > 0) {
            depthDir = sideHit.method_10166().method_10178() ? player.method_5735() : sideHit.method_10153();
            widthDir = depthDir.method_10170();
        } else {
            depthDir = class_2350.field_11036;
            widthDir = class_2350.field_11036;
        }
        return () -> new TreeIterator(world, state.method_26204(), origin, widthDir, extraWidth, depthDir, extraDepth);
    }

    public TreeAOEIterator(int width, int depth) {
        this.width = width;
        this.depth = depth;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<TreeAOEIterator> {
        private Loader() {
        }

        @Override
        public TreeAOEIterator deserialize(JsonObject json) {
            int width = JsonUtils.getIntMin(json, "width_bonus", 0);
            int depth = JsonUtils.getIntMin(json, "depth_bonus", 0);
            return new TreeAOEIterator(width, depth);
        }

        @Override
        public TreeAOEIterator fromNetwork(class_2540 buffer) {
            int width = buffer.method_10816();
            int depth = buffer.method_10816();
            return new TreeAOEIterator(width, depth);
        }

        @Override
        public void serialize(TreeAOEIterator object, JsonObject json) {
            json.addProperty("width_bonus", (Number)object.width);
            json.addProperty("depth_bonus", (Number)object.depth);
        }

        @Override
        public void toNetwork(TreeAOEIterator object, class_2540 buffer) {
            buffer.method_10804(object.width);
            buffer.method_10804(object.depth);
        }
    }

    public static class TreeIterator
    extends AbstractIterator<class_2338> {
        private final Queue<TreePos> upcomingPositions = new ArrayDeque<TreePos>();
        private final class_2338.class_2339 mutable = new class_2338.class_2339();
        private final Set<class_2338> branchVisited = new HashSet<class_2338>();
        private final class_1937 world;
        private final class_2248 filter;
        private final int minX;
        private final int maxX;
        private final int minZ;
        private final int maxZ;

        public TreeIterator(class_1937 world, class_2248 filter, class_2338 origin, class_2350 widthDir, int extraWidth, class_2350 depthDir, int extraDepth) {
            int minZ;
            int minX;
            this.world = world;
            this.filter = filter;
            this.upcomingPositions.add(new TreePos(origin.method_10084(), false));
            int maxX = minX = origin.method_10263();
            int maxZ = minZ = origin.method_10260();
            if (extraDepth > 0 || extraWidth > 0) {
                for (int d = 0; d <= extraDepth; ++d) {
                    for (int w = -extraWidth; w <= extraWidth; ++w) {
                        if (d == 0 && w == 0) continue;
                        this.mutable.method_10101((class_2382)origin).method_10104(depthDir, d).method_10104(widthDir, w);
                        if (!this.isValidBlock((class_2338)this.mutable)) continue;
                        this.upcomingPositions.add(new TreePos((class_2338)this.mutable, true));
                        if (this.mutable.method_10263() < minX) {
                            minX = this.mutable.method_10263();
                        }
                        if (this.mutable.method_10263() > maxX) {
                            maxX = this.mutable.method_10263();
                        }
                        if (this.mutable.method_10260() < minZ) {
                            minZ = this.mutable.method_10260();
                        }
                        if (this.mutable.method_10260() <= maxZ) continue;
                        maxZ = this.mutable.method_10260();
                    }
                }
            }
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        private boolean isValidBlock(class_2338 pos) {
            return this.world.method_8320(pos).method_26204() == this.filter;
        }

        private boolean outsideTrunk(class_2338 pos) {
            return pos.method_10263() < this.minX || pos.method_10263() > this.maxX || pos.method_10260() < this.minZ || pos.method_10260() > this.maxZ;
        }

        private boolean isBranch(class_2338 pos) {
            int deltaZ;
            if (!this.outsideTrunk(pos)) {
                return false;
            }
            int deltaX = Math.min(Math.abs(pos.method_10263() - this.minX), Math.abs(pos.method_10263() - this.maxX));
            if (deltaX + (deltaZ = Math.min(Math.abs(pos.method_10260() - this.minZ), Math.abs(pos.method_10260() - this.maxZ))) > 10 || this.branchVisited.contains(pos)) {
                return false;
            }
            this.branchVisited.add(pos.method_10062());
            return this.isValidBlock(pos);
        }

        private void addBranch(class_2350 direction) {
            this.upcomingPositions.add(new TreePos((class_2338)this.mutable, direction));
        }

        private void tryBranch(class_2350 direction) {
            if (this.isBranch((class_2338)this.mutable)) {
                TreePos branchPos = new TreePos((class_2338)this.mutable, direction);
                if (!this.world.method_8320((class_2338)this.mutable.method_10100(0, -1, 0)).method_26225()) {
                    this.upcomingPositions.add(branchPos);
                }
            }
        }

        protected class_2338 computeNext() {
            while (!this.upcomingPositions.isEmpty()) {
                TreePos treePos = this.upcomingPositions.remove();
                if (treePos.direction == class_2350.field_11036) {
                    boolean isMaxZ;
                    boolean isTreeUp = treePos.isChecked || this.isValidBlock((class_2338)treePos.pos);
                    for (class_2350 direction : class_2350.class_2353.field_11062) {
                        this.mutable.method_10101((class_2382)treePos.pos).method_10098(direction);
                        this.tryBranch(!isTreeUp ? class_2350.field_11036 : direction);
                    }
                    if (!isTreeUp) continue;
                    boolean isMinX = treePos.pos.method_10263() == this.minX;
                    boolean isMaxX = treePos.pos.method_10263() == this.maxX;
                    boolean isMinZ = treePos.pos.method_10260() == this.minZ;
                    boolean bl = isMaxZ = treePos.pos.method_10260() == this.maxZ;
                    if (isMinX) {
                        if (isMinZ) {
                            this.mutable.method_10101((class_2382)treePos.pos).method_10100(-1, 0, -1);
                            this.tryBranch(class_2350.field_11039);
                        }
                        if (isMaxZ) {
                            this.mutable.method_10101((class_2382)treePos.pos).method_10100(-1, 0, 1);
                            this.tryBranch(class_2350.field_11039);
                        }
                    }
                    if (isMaxX) {
                        if (isMinZ) {
                            this.mutable.method_10101((class_2382)treePos.pos).method_10100(1, 0, -1);
                            this.tryBranch(class_2350.field_11034);
                        }
                        if (isMaxZ) {
                            this.mutable.method_10101((class_2382)treePos.pos).method_10100(1, 0, 1);
                            this.tryBranch(class_2350.field_11034);
                        }
                    }
                    this.mutable.method_10101((class_2382)treePos.pos);
                    this.upcomingPositions.add(treePos.move());
                    if (this.outsideTrunk((class_2338)treePos.pos)) {
                        this.branchVisited.add((class_2338)treePos.pos);
                    }
                    return this.mutable;
                }
                this.mutable.method_10101((class_2382)treePos.pos).method_10100(0, 1, 0);
                if (this.isBranch((class_2338)this.mutable)) {
                    this.addBranch(treePos.direction);
                } else if (this.isBranch((class_2338)this.mutable.method_10098(treePos.direction).method_10100(0, -1, 0))) {
                    this.addBranch(treePos.direction);
                } else if (this.isBranch((class_2338)this.mutable.method_10100(0, 1, 0))) {
                    this.addBranch(treePos.direction);
                }
                class_2350 rotated = treePos.direction.method_10170();
                this.mutable.method_10101((class_2382)treePos.pos).method_10098(rotated);
                if (this.isBranch((class_2338)this.mutable)) {
                    this.addBranch(rotated);
                } else if (this.isBranch((class_2338)this.mutable.method_10100(0, 1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((class_2338)this.mutable.method_10098(treePos.direction).method_10100(0, -1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((class_2338)this.mutable.method_10100(0, 1, 0))) {
                    this.addBranch(rotated);
                }
                rotated = rotated.method_10153();
                this.mutable.method_10101((class_2382)treePos.pos).method_10098(rotated);
                if (this.isBranch((class_2338)this.mutable)) {
                    this.addBranch(rotated);
                } else if (this.isBranch((class_2338)this.mutable.method_10100(0, 1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((class_2338)this.mutable.method_10098(treePos.direction).method_10100(0, -1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((class_2338)this.mutable.method_10100(0, 1, 0))) {
                    this.addBranch(rotated);
                }
                return treePos.pos;
            }
            return (class_2338)this.endOfData();
        }
    }

    private static class TreePos {
        private final class_2338.class_2339 pos;
        private final class_2350 direction;
        private boolean isChecked;

        TreePos(class_2338 pos, boolean isChecked) {
            this.pos = pos.method_25503();
            this.direction = class_2350.field_11036;
            this.isChecked = isChecked;
        }

        TreePos(class_2338 pos, class_2350 direction) {
            this.pos = pos.method_25503();
            this.direction = direction;
            this.isChecked = true;
        }

        public TreePos move() {
            this.pos.method_10098(this.direction);
            this.isChecked = false;
            return this;
        }
    }
}

